/*
 * Decompiled with CFR 0.152.
 */
package jode.flow;

import java.io.IOException;
import jode.decompiler.TabbedPrintWriter;
import jode.expr.CompareUnaryOperator;
import jode.expr.Expression;
import jode.expr.InvokeOperator;
import jode.expr.PopOperator;
import jode.expr.StoreInstruction;
import jode.flow.EmptyBlock;
import jode.flow.IfThenElseBlock;
import jode.flow.InstructionBlock;
import jode.flow.Jump;
import jode.flow.SequentialBlock;
import jode.flow.StructuredBlock;
import jode.flow.VariableStack;

public class SpecialBlock
extends StructuredBlock {
    public static int DUP = 0;
    public static int SWAP = 1;
    public static int POP = 2;
    private static String[] output = new String[]{"DUP", "SWAP", "POP"};
    int type;
    int count;
    int depth;

    public VariableStack mapStackToLocal(VariableStack variableStack) {
        VariableStack variableStack2 = variableStack.executeSpecial(this);
        return super.mapStackToLocal(variableStack2);
    }

    public void removePush() {
        this.removeBlock();
    }

    public void dumpInstruction(TabbedPrintWriter tabbedPrintWriter) throws IOException {
        tabbedPrintWriter.println(output[this.type] + (this.count == 1 ? "" : "2") + (this.depth == 0 ? "" : "_X" + this.depth));
    }

    public boolean doTransformations() {
        return this.type == SWAP && this.removeSwap(this.flowBlock.lastModified) || this.type == POP && this.removePop(this.flowBlock.lastModified);
    }

    public boolean removeSwap(StructuredBlock structuredBlock) {
        if (structuredBlock.outer instanceof SequentialBlock && structuredBlock.outer.outer instanceof SequentialBlock && structuredBlock.outer.getSubBlocks()[0] instanceof InstructionBlock && structuredBlock.outer.outer.getSubBlocks()[0] instanceof InstructionBlock) {
            InstructionBlock instructionBlock = (InstructionBlock)structuredBlock.outer.outer.getSubBlocks()[0];
            InstructionBlock instructionBlock2 = (InstructionBlock)structuredBlock.outer.getSubBlocks()[0];
            Expression expression = instructionBlock.getInstruction();
            Expression expression2 = instructionBlock2.getInstruction();
            if (expression.isVoid() || expression2.isVoid() || expression.getFreeOperandCount() != 0 || expression2.getFreeOperandCount() != 0 || expression.hasSideEffects(expression2) || expression2.hasSideEffects(expression)) {
                return false;
            }
            structuredBlock.outer.replace(instructionBlock.outer);
            instructionBlock.replace(this);
            instructionBlock.moveJump(this.jump);
            instructionBlock.flowBlock.lastModified = instructionBlock;
            return true;
        }
        return false;
    }

    public boolean removePop(StructuredBlock structuredBlock) {
        if (structuredBlock.outer instanceof SequentialBlock && structuredBlock.outer.getSubBlocks()[0] instanceof InstructionBlock) {
            if (this.jump != null && this.jump.destination == null) {
                return false;
            }
            InstructionBlock instructionBlock = (InstructionBlock)structuredBlock.outer.getSubBlocks()[0];
            Expression expression = instructionBlock.getInstruction();
            if (expression.getType().stackSize() == this.count) {
                StructuredBlock structuredBlock2;
                if (expression instanceof InvokeOperator || expression instanceof StoreInstruction) {
                    Expression expression2 = new PopOperator(expression.getType()).addOperand(expression);
                    instructionBlock.setInstruction(expression2);
                    structuredBlock2 = instructionBlock;
                } else {
                    Expression expression3 = new CompareUnaryOperator(expression.getType(), 27).addOperand(expression);
                    IfThenElseBlock ifThenElseBlock = new IfThenElseBlock(expression3);
                    ifThenElseBlock.setThenBlock(new EmptyBlock());
                    structuredBlock2 = ifThenElseBlock;
                }
                structuredBlock2.moveDefinitions(structuredBlock.outer, structuredBlock);
                structuredBlock2.moveJump(this.jump);
                if (this == structuredBlock) {
                    structuredBlock2.replace(structuredBlock.outer);
                    this.flowBlock.lastModified = structuredBlock2;
                } else {
                    structuredBlock2.replace(this);
                    structuredBlock.replace(structuredBlock.outer);
                }
                return true;
            }
        }
        return false;
    }

    public SpecialBlock(int n, int n2, int n3, Jump jump) {
        this.type = n;
        this.count = n2;
        this.depth = n3;
        this.setJump(jump);
    }
}

